```
set nocompatible 

call plug#begin()

Plug 'vim-scripts/Mustang2'
Plug 'vim-airline/vim-airline'
Plug 'vim-airline/vim-airline-themes'

Plug 'tpope/vim-sensible'
Plug 'jeffkreeftmeijer/vim-numbertoggle'
Plug 'scrooloose/syntastic'

call plug#end()

" syntastic config
" set statusline+=%#warningmsg#
" set statusline+=%{SyntasticStatuslineFlag()}
" set statusline+=%*

let g:syntastic_always_populate_loc_list = 1
let g:syntastic_auto_loc_list = 1
let g:syntastic_check_on_open = 0
let g:syntastic_check_on_wq = 1
let g:syntastic_php_checkers = ['php']
" let g:syntastic_javascript_checkers = ['eslint']

" airline configs
let g:airline_theme = 'base16_chalk'
let g:airline_powerline_fonts = 1
let g:airline#extensions#tabline#enabled = 1
let g:airline#extensions#tabline#formatter = 'unique_tail_improved'


" let g:is_posix = 1                          " Better highlighting of shell files

colorscheme Mustang
" set background=dark

set encoding=utf-8
set cursorline
set nu rnu

" searching
" set hlsearch                                " Highlight searches
" set incsearch                               " Highlight search results instantly
" set ignorecase                              " Ignore case
" set smartcase                               " Override 'ignorecase' option if the search contains upper case characters.

" indentation
filetype plugin indent on                   " Enable automatic filetype detection, filetype-specific plugins/indentation
autocmd Filetype python setl et tabstop=4 sw=4 sts=4 " python indention
autocmd Filetype json setl et tabstop=4 sw=4 sts=4 " json indention

set shiftwidth=2                              " Number of spaces to use in each autoindent step
set tabstop=2                                 " Two tab spaces
set softtabstop=2                             " Number of spaces to skip or insert when <BS>ing or <Tab>ing
" set expandtab                               " Spaces instead of tabs for better cross-editor compatibility
" set autoindent                              " Keep the indent when creating a new line
set smarttab                                " Use shiftwidth and softtabstop to insert or delete (on <BS>) blanks
" set cindent                                 " Recommended seting for automatic C-style indentation
" set autoindent                              " Automatic indentation in non-C files

set list lcs=tab:│\ 
hi SpecialKey ctermfg=1 guifg=#111111
call matchadd('SpecialKey', '[\│]')
hi Conceal ctermbg=NONE guibg=NONE
call matchadd('Conceal', '[ \t]')
set list!

nnoremap <f5> :set list!<cr>


" Misc
" set nowrap                                  " I don't always wrap lines...
" set linebreak                               " ...but when I do, I wrap whole words.
" set t_Co=256                                " Support for xterm with 256 colors
" set number                                  " Show line numbers
" set ruler                                   " Show ruler
set noswapfile                              " Don't create annoying *.swp files